/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsEvent;
import com.ibm.hwmca.fw.fcs.FcsEventListener;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsService;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletClientManager;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rbf.RbfException;
import com.ibm.hwmca.fw.rbf.impl.HandlerManager;
import com.ibm.hwmca.fw.rbf.impl.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.rbf.impl.RbfChatletClient;
import com.ibm.hwmca.fw.rbf.impl.RbfInternalConstants;
import com.ibm.hwmca.fw.rbf.impl.RbfMsg;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager;
import com.ibm.hwmca.fw.rbf.impl.RequestManager;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class CommManager
implements RbfInternalConstants,
FcsService,
FcsEventListener {
    private static final String TRACE_MASKT = "XRBFCMGT";
    private static final String TRACE_MASKF = "XRBFCMGF";
    private static final String TRACE_MASKD = "XRBFCMGD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RBF-CommMgr");
    private static CommManager commManager = null;
    private static final FcsServiceId serviceId = new FcsServiceId("com.ibm.hwmca.fw.rbf", 2.0);
    private Map chatletClients = new HashMap();
    private Object chatletLock = new Object();
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rbf$impl$RbfReply;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rbf$impl$RbfMsg;

    private CommManager() {
        FcsServer fcsServer = FcsServer.getFcsServer();
        fcsServer.addLocalService(serviceId, this);
        fcsServer.addFcsEventListener(this);
        Trace.trace(TRACE_MASKT, "<> CommManager()");
    }

    public static synchronized CommManager getCommManager() {
        if (commManager == null) {
            commManager = new CommManager();
        }
        return commManager;
    }

    RbfReply send(RbfMsg msg, MachineId target) throws RbfException {
        return this.send(msg, target, 0);
    }

    RbfReply send(RbfMsg msg, MachineId target, int soTimeout) throws RbfException {
        Trace.trace(TRACE_MASKT, "-> send(" + RbfUtils.getMachineInfo(target) + ")");
        FcsServer fcsServer = FcsServer.getFcsServer();
        MachineId localMachine = fcsServer.getLocalMachineId();
        RbfReply reply = null;
        if (target.equals(localMachine)) {
            reply = this.sendLocal(msg, target);
        } else {
            int commonProtocol = this.getCommonVersion(target);
            if (commonProtocol == -1) {
                String desc = "Version 2 unsupported by target";
                Trace.trace(TRACE_MASKF, desc);
                throw new RbfException(desc);
            }
            if (commonProtocol == 1) {
                reply = this.sendRemote(msg, target, soTimeout, commonProtocol);
            } else if (commonProtocol >= 2) {
                reply = this.sendChatlet(msg, target, soTimeout, commonProtocol);
            } else {
                String desc = "Version 2 unsupported by target";
                Trace.trace(TRACE_MASKF, desc);
                throw new RbfException(desc);
            }
        }
        Trace.trace(TRACE_MASKT, "<- send()");
        return reply;
    }

    private RbfReply sendLocal(RbfMsg msg, MachineId localMachine) throws RbfException {
        Trace.trace(TRACE_MASKT, "-> sendLocal()");
        String localMachineInfo = RbfUtils.getMachineInfo(localMachine);
        int protocol = 2;
        String desc = "target=" + localMachineInfo + ", protocol=" + protocol + "\nOutgoing " + msg;
        Trace.trace(TRACE_MASKF, desc);
        RbfReply reply = msg.process(localMachine, protocol);
        String desc2 = "Incoming " + reply + "\nsender=" + localMachineInfo + ", protocol=" + protocol;
        Trace.trace(TRACE_MASKF, desc2);
        reply.process(localMachine, protocol);
        Trace.trace(TRACE_MASKT, "<- sendLocal()");
        return reply;
    }

    private RbfReply sendRemote(RbfMsg msg, MachineId target, int soTimeout, int protocol) throws RbfException {
        Object reply;
        Trace.trace(TRACE_MASKT, "-> sendRemote(" + soTimeout + ", " + protocol + ")");
        Socket socket = null;
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        String targetInfo = RbfUtils.getMachineInfo(target);
        try {
            FcsConnection connection = null;
            if (protocol == 2) {
                connection = FcsConnection.connect(target, serviceId);
            } else {
                FcsServiceId tempServiceId = new FcsServiceId("com.ibm.hwmca.fw.rbf", protocol);
                connection = FcsConnection.connect(target, tempServiceId);
            }
            socket = connection.getSocket();
            if (soTimeout > 0) {
                socket.setSoTimeout(soTimeout);
            }
            oos = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            oos.writeInt(protocol);
            oos.flush();
            ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
            int targetProtocol = ois.readInt();
            int commonProtocol = this.getCommonRbfVersion(targetProtocol);
            Trace.trace(TRACE_MASKF, "target=" + targetInfo + ", protocol=" + commonProtocol);
            if (commonProtocol == -1) {
                String desc = "Version 2 unsupported by target";
                Trace.trace(TRACE_MASKF, desc);
                throw new RbfException(desc);
            }
            Trace.trace(TRACE_MASKF, "Outgoing " + msg);
            oos.writeObject(msg);
            oos.flush();
            reply = ois.readObject();
            String desc = "Incoming " + reply + "\n" + "sender=" + targetInfo + ", protocol=" + commonProtocol;
            Trace.trace(TRACE_MASKF, desc);
            if (!(reply instanceof RbfReply)) {
                desc = "Unexpected reply " + reply.getClass().getName() + " from " + targetInfo + ", expected " + (class$com$ibm$hwmca$fw$rbf$impl$RbfReply == null ? (class$com$ibm$hwmca$fw$rbf$impl$RbfReply = CommManager.class$("com.ibm.hwmca.fw.rbf.impl.RbfReply")) : class$com$ibm$hwmca$fw$rbf$impl$RbfReply).getName();
                Trace.trace(TRACE_MASKF, desc);
                RbfException rbfe = new RbfException(desc);
                FrameworkLog fl = new FrameworkLog(classLogInfo, 1060, rbfe);
                fl.add(RbfUtils.getLoggingInfo());
                fl.log();
                throw rbfe;
            }
            ((RbfReply)reply).process(target, commonProtocol);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e.getClass().getName() + " sending " + msg.getClass().getName() + " to " + targetInfo + ":\n " + RbfUtils.getStackTrace(e));
            throw new RbfException(e.getMessage());
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ioe) {}
            Trace.trace(TRACE_MASKT, "<- sendRemote()");
        }
        return (RbfReply)reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RbfReply sendChatlet(RbfMsg msg, MachineId target, int soTimeout, int protocol) throws RbfException {
        Trace.trace(TRACE_MASKT, "-> sendChatlet(" + soTimeout + ", " + protocol + ")");
        String targetInfo = RbfUtils.getMachineInfo(target);
        RbfReply reply = null;
        try {
            RbfChatletClient chatletClient;
            Object object = this.chatletLock;
            synchronized (object) {
                chatletClient = (RbfChatletClient)this.chatletClients.get(target);
                if (chatletClient == null) {
                    chatletClient = new RbfChatletClient(target);
                    ChatletClientManager ccm = ChatletClientManager.getChatletClientManager(target);
                    ccm.registerChatlet(chatletClient);
                    this.chatletClients.put(target, chatletClient);
                }
            }
            reply = chatletClient.sendMsg(msg, soTimeout, protocol);
        }
        catch (Exception e) {
            if (e instanceof RbfException) {
                throw (RbfException)e;
            }
            Trace.trace(TRACE_MASKF, e.getClass().getName() + " sending " + msg.getClass().getName() + " to " + targetInfo + ":\n " + RbfUtils.getStackTrace(e));
            throw new RbfException(e);
        }
        Trace.trace(TRACE_MASKT, "<- sendChatlet()");
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processConnection(FcsConnection connection) {
        Trace.trace(TRACE_MASKT, "-> processConnection()");
        ObjectInputStream ois = null;
        ObjectOutputStream oos = null;
        Socket socket = connection.getSocket();
        MachineId sender2 = connection.getMachineId();
        String senderInfo = RbfUtils.getMachineInfo(sender2);
        try {
            ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
            int senderProtocol = ois.readInt();
            int commonProtocol = this.getCommonRbfVersion(senderProtocol);
            oos = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            oos.writeInt(commonProtocol);
            oos.flush();
            Trace.trace(TRACE_MASKF, "sender=" + senderInfo + ", protocol=" + commonProtocol);
            if (commonProtocol != -1) {
                Object msg = ois.readObject();
                Trace.trace(TRACE_MASKF, "Incoming " + msg);
                if (!(msg instanceof RbfMsg)) {
                    String desc = "Unexpected message " + msg.getClass().getName() + " from " + senderInfo + ", expected " + (class$com$ibm$hwmca$fw$rbf$impl$RbfMsg == null ? (class$com$ibm$hwmca$fw$rbf$impl$RbfMsg = CommManager.class$("com.ibm.hwmca.fw.rbf.impl.RbfMsg")) : class$com$ibm$hwmca$fw$rbf$impl$RbfMsg).getName();
                    Trace.trace(TRACE_MASKF, desc);
                    RbfException rbfe = new RbfException(desc);
                    FrameworkLog fl = new FrameworkLog(classLogInfo, 1060, rbfe);
                    fl.add(RbfUtils.getLoggingInfo());
                    fl.log();
                    throw rbfe;
                }
                RbfReply reply = ((RbfMsg)msg).process(sender2, commonProtocol);
                String desc = "Outgoing " + reply + "\ntarget=" + senderInfo + ", protocol=" + commonProtocol;
                Trace.trace(TRACE_MASKF, desc);
                oos.writeObject(reply);
                oos.flush();
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e.getClass().getName() + " processing " + "connection from " + senderInfo + ":\n " + RbfUtils.getStackTrace(e));
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ioe) {}
            Trace.trace(TRACE_MASKT, "<- processConnection()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChatletClient(RbfChatletClient chatletClient) {
        Object object = this.chatletLock;
        synchronized (object) {
            MachineId target = chatletClient.getTarget();
            this.chatletClients.remove(target);
        }
    }

    int getCommonRbfVersion(int version) {
        if (version == -1) {
            return version;
        }
        if (version < 2) {
            return version;
        }
        return 2;
    }

    int getCommonVersion(MachineId machine) {
        FcsServer fcsServer = FcsServer.getFcsServer();
        FcsServiceId rbfService = fcsServer.getServiceId(machine, "com.ibm.hwmca.fw.rbf");
        if (rbfService != null) {
            int version = (int)rbfService.getVersion();
            if (version < 2) {
                return version;
            }
            return 2;
        }
        return -1;
    }

    Set getPeers() {
        FcsServer fcsServer = FcsServer.getFcsServer();
        Set peers = fcsServer.getSupportingMachines(serviceId, 7);
        peers.remove(fcsServer.getLocalMachineId());
        return peers;
    }

    boolean containsRbfService(Set services) {
        String rbfServiceName = serviceId.getServiceName();
        Iterator iterator = services.iterator();
        while (iterator.hasNext()) {
            FcsServiceId serviceId = (FcsServiceId)iterator.next();
            if (!serviceId.getServiceName().equals(rbfServiceName)) continue;
            return true;
        }
        return false;
    }

    public void fcsStateChanged(FcsEvent event) {
        Trace.trace(TRACE_MASKT, "-> fcsStateChanged()");
        MachineId machine = event.getMachineId();
        Set services = event.getServices();
        if (this.containsRbfService(services)) {
            int type = event.getEventType();
            int details = event.getEventDetails();
            String machineInfo = RbfUtils.getMachineInfo(machine);
            if (type == 1) {
                if (details == 51) {
                    Trace.trace(TRACE_MASKF, "Machine added: " + machineInfo);
                } else if (details == 53) {
                    Trace.trace(TRACE_MASKF, "Machine recycled: " + machineInfo);
                } else if (details == 52) {
                    Trace.trace(TRACE_MASKF, "Machine removed: " + machineInfo);
                } else if (details == 54) {
                    Trace.trace(TRACE_MASKF, "Machine changed: " + machineInfo);
                    this.machineChanged(machine, event.getOldMachineId());
                }
            } else if (type == 2) {
                if (details == 100) {
                    Trace.trace(TRACE_MASKF, "Service added: " + machineInfo);
                } else if (details == 101) {
                    Trace.trace(TRACE_MASKF, "Service removed: " + machineInfo);
                }
            }
            try {
                HandlerManager.getHandlerManager().fcsStateChanged(event);
                RequestManager.getRequestManager().fcsStateChanged(event);
                RequestHandlingManager.getRequestHandlingManager().fcsStateChanged(event);
            }
            catch (PersistenceNotInitializedException pnie) {
                // empty catch block
            }
        }
        Trace.trace(TRACE_MASKT, "<- fcsStateChanged()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void machineChanged(MachineId machine, MachineId oldMachine) {
        Object object = this.chatletLock;
        synchronized (object) {
            if (this.chatletClients.containsKey(oldMachine)) {
                RbfChatletClient chatletClient = (RbfChatletClient)this.chatletClients.get(oldMachine);
                chatletClient.setTarget(machine);
                this.chatletClients.remove(oldMachine);
                this.chatletClients.put(machine, chatletClient);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

